/*
//# PRECIPITATION Script.  Beta Release 2.

 Usage:
   EvaluateScript("precipitation.js");
   var SnowField = new SnowFactory(100,  LoadImage("snowflake.png") ,true,1);
   SnowField.startSnowing(); // <-- Best called in the Map's Entry Script.
   SetRenderScript("Render_Update()");
   function Render_Update()
   {
    SnowField.UpdateAndDraw();
   }

   Known Bugs: When walking down, snow decreces, patched with randomness.

		Functions in this library:

SnowFactory(amount,flakeimage,juststarted,wind)
	Create a new SnowFactory object.
	amount: Amount of snowflakes
	flakeimage: an image
	juststarted: boolean. does it start snowing, or is it already snowing?
	wind: integer, -1 or 1 for slow wind, 10 is a storm. Makes the snow go diagonal.
	example:
		var SnowField = new SnowFactory(100,  LoadImage("snowflake.png") ,true,1);

startSnowing()
	Start snowing. (And starts using lots of CPU power ^_^ ) 
	example:
		SnowField.startSnowing();

isSnowing()
	Boolean. Returns if it is snowing (snowflakes are active)
	example:
		if (SnowField.isSnowing()) {}

isFlaking()
	Boolean. Returns true if new snowflakes are being generated.
	example:
		if (SnowField.isFlaking()) {}

stopSnowing()
	It abruptly stops snowing.
	example:
		SnowField.stopSnowing();

stopFlaking()
	No new snowflakes will be generated. It will take a while until
	isSnowing() is false.
	example:
		SnowField.stopFlaking();


*******************************************************************************

RainFactory(amount,splashsprite,splashdirection,juststarted,wind,
				dropspeed,droplength,raincolor,thunder_probability)
	Create a new SnowFactory object.
	amount: Amount of raindrops
	splashsprite: the name of an rss file with a splash. 
			Put 0 if you dont want to use it.
	juststarted: boolean. does it start raining, or is it already raining? 
			Splashes arent created right away. The fx is not very visible.
	wind: integer, -1 or 1 for slow wind, 10 is a storm. Makes the rain go diagonal.
	dropspeed: Amount of pixels the rain falls each FlipScreen()
	droplength: Length of the line representing a falling raindrop.
	raincolor: enter a color here. Put numerical 0 here if you want the default
	thunder_probability: Very ugly. 0 is recommended, else a very small number, like 0.007
			(no sound though, maybe if someone added real thunder...)
	example:
		var RainField = new RainFactory(50,"rainfx.rss","splash",true,-2,8,40,0,.002);

isRaining()
	Boolean. Returns if it is raining (raindrops are active)
	example:
		if (RainField.isRaining()) {}

isDropping()
	Boolean. Returns if new raindrops are being generated.
	example:
		if (RainField.isDropping()) {}

stopRaining()
	It abruptly stops raining.
	example:
		RainField.stopRaining();

stopDropping()
	No new raindrops will be generated. It will take a while until
	isRaining() is false.
	example:
		RainField.stopDropping();

*******************************************************************************

UpdateAndDraw()
	Renders the snow/rain to the Screen. Put this command inside a render script.
	The mapengine must be running when you call this command.
	It is very efficient when its not (snow/rain)ing, so dont do:
	if (RainField.isRaining()) {RainField.UpdateAndDraw()} // BAD! DONT!
	examples:
		SnowField.UpdateAndDraw();
		RainField.UpdateAndDraw();

*/
//----------------------------------------------------------------------------//

function SnowFactory(amount,flakeimage,juststarted,wind)
{
  if (this instanceof SnowFactory == false) {
    return new SnowFactory(amount,flakeimage);
  }
  this.flake      = flakeimage;
  this.snowing    = false;
  this.moreflakes = false;
  this.juststarted= juststarted;
  this.offsetX=undefined;
  this.offsetY=undefined;
  this.GSW=GetScreenWidth();
  this.GSH=GetScreenHeight();
  this.GSH80=this.GSH+80;
  this.GSH100=this.GSH+120;
  if (typeof wind != "undefined") this.wind=wind-1; else this.wind=-1;

  this.flakes = new Array(amount);
  for (var i=0;i<this.flakes.length;++i) 
  {
    this.flakes[i] = new _Particle(
		Math.floor(Math.random()*this.GSW),
		Math.floor(Math.random()*this.GSH)-5,
		10+Math.floor(Math.random()*this.GSH),
		1);
   if (juststarted) this.flakes[i].y=this.GSH+5;
  }
}
//----------------------------------------------------------------------------//
function RainFactory(amount,splashsprite,splashdirection,juststarted,wind,dropspeed,droplength,raincolor,thunder_probability)
{
  if (this instanceof RainFactory == false) {
    return new RainFactory(amount,flakeimage);
  }

  this.raining    = false;
  this.moredrops = false;
  this.juststarted= juststarted;
  this.offsetX=undefined;
  this.offsetY=undefined;
  this.GSW=GetScreenWidth();
  this.GSH=GetScreenHeight();
  this.GSH80=this.GSH+80;
  this.GSH100=this.GSH+120;
  this.thunder_probability=thunder_probability||0;
  this.dropspeed=dropspeed||8;
  this.wind=wind||0;
  var theta=(wind)? Math.atan(this.dropspeed/wind):Math.PI/2;
  this.lx=-Math.floor(Math.cos(theta)*droplength); //deltaLength rain line(x1,y1, x2,y2)).
  this.ly=-Math.floor(Math.sin(theta)*droplength);

  this.dosplash=false;
  if (typeof splashsprite=="string")
  {
	this.dosplash=true;
	this.splash= LoadSpriteset(splashsprite);
	for(var i=0;i<this.splash.directions.length;++i)
	{
		if (this.splash.directions[i].name==splashdirection)
		{
			this.splashframesMax=this.splash.directions[i].frames.length;
			this.splashimages=new Array(this.splashframesMax);
			for(var j=0;j<this.splashframesMax;++j)
				this.splashimages[j]= this.splash.images[this.splash.directions[i].frames[j].index];
		}
	}
  }
  this.raincolor=raincolor||CreateColor(200,230,250,100);
  this.drops= new Array(amount);
  for (var i=0;i<this.drops.length;++i) 
  {
    this.drops[i] = new _Particle(
		Math.floor(Math.random()*this.GSW),
		Math.floor(Math.random()*this.GSH),
		10+Math.floor(Math.random()*this.GSH),
		1);
   //if (juststarted) this.drops[i].y=this.GSH+5;
  }
}


//----------------------------------------------------------------------------//
function _Particle(x,y,h,w)
{
  if (this instanceof _Particle == false) { return new _Particle(x,y,h,w); }
  this.x = x;
  this.y = y;
  this.h = h;
  this.w = w;
  this.i=0; //frame index used in rain splashing
}

SnowFactory.prototype.isSnowing = function() { return this.snowing; }
RainFactory.prototype.isRaining = function() { return this.raining; }

SnowFactory.prototype.isFlaking = function() { return this.moreflakes; }
RainFactory.prototype.isDropping = function() {	return this.moredrops; }

SnowFactory.prototype.stopFlaking = function() { this.moreflakes=false; }
RainFactory.prototype.stopDropping = function() { this.moredrops=false; }

SnowFactory.prototype.stopSnowing = function() { this.snowing=false; }
RainFactory.prototype.stopRaining = function() { this.raining=false; }

SnowFactory.prototype.startSnowing = function() {
var Floor=Math.floor;
var Random=Math.random;
var i=this.flakes.length-1;
  do
  { var tfi=this.flakes[i];
    tfi.x = Floor(Random()*this.GSW);
    tfi.y = Floor(Random()*this.GSH)-5;
    tfi.h = 10+Floor(Random()*this.GSH);
    tfi.w = 1;
    if (this.juststarted) tfi.y=this.GSH+5;
  }
  while (i--);
	this.moreflakes=true;
	this.snowing=true;
	//this.offsetX=MapToScreenX(0,0);
	//this.offsetY=MapToScreenY(0,0);
}

RainFactory.prototype.startRaining = function() {
var Floor=Math.floor;
var Random=Math.random;
var i=this.drops.length-1;
  do
  {
    this.drops[i].x = Floor(Random()*this.GSW);
    this.drops[i].y = Floor(Random()*this.GSH);
    this.drops[i].h = Floor(Random()*this.GSH);
    this.drops[i].w = 1;
    this.drops[i].i = 0;
    if (this.juststarted) this.drops[i].y=-Floor(Random()*this.GSH);
  }
  while (i--);
	this.moredrops=true;
	this.raining=true;
	//this.offsetX=MapToScreenX(0,0);
	//this.offsetY=MapToScreenY(0,0);
}


//----------------------------------------------------------------------------//

SnowFactory.prototype.UpdateAndDraw = function()
{
 if(this.snowing)
 {
  var INRS=true;
  var NewOffsetX=0; var NewOffsetY=0;
  if(typeof this.offsetX=="undefined")
  {
    this.offsetX=MapToScreenX(0,0);
    this.offsetY=MapToScreenY(0,0);
  }
  else
  {
    var NewOffsetX=MapToScreenX(0,0)-this.offsetX;
    var NewOffsetY=MapToScreenY(0,0)-this.offsetY;
    this.offsetX+=NewOffsetX;
    this.offsetY+=NewOffsetY;
  }
  var Floor=Math.floor;
  var Random=Math.random;
  var i=this.flakes.length-1;
  do
  {
    var tfi=this.flakes[i];
    --tfi.h; 
    if(tfi.h>0)
    { INRS=false;
      tfi.x=(tfi.x+NewOffsetX)%this.GSW;
      if(tfi.x<0) tfi.x+=this.GSW;
      if(NewOffsetY) tfi.y = (tfi.y+NewOffsetY)%(this.GSH80);
      if(tfi.h>100){
	tfi.x+=Floor(Random()*3)+this.wind;++tfi.y;
	}
      this.flake.zoomBlit(tfi.x,tfi.y,.1+(tfi.h*0.00285));
    }
    else
    {
      if(this.moreflakes)
      {
	tfi.x=Floor(Random()*this.GSW);
	if(NewOffsetY<0)tfi.y=Floor(Random()*this.GSW)-5;
	else tfi.y=-5;
	tfi.h=Floor(Random()*this.GSH100);
      }
    }
  }
  while (i--);
  this.snowing=!INRS;
 }
}

//----------------------------------------------------------------------------//


RainFactory.prototype.UpdateAndDraw = function()
{
 if(this.raining)
 {
  if (FXlevel = "high")
  {  ApplyColorMask(Overcast) }
 
  var INRS=true;
  var NewOffsetX=0; var NewOffsetY=0;
  if(typeof this.offsetX=="undefined")
  {
    this.offsetX=MapToScreenX(0,0);
    this.offsetY=MapToScreenY(0,0);
  }
  else
  {
    var NewOffsetX=MapToScreenX(0,0)-this.offsetX;
    var NewOffsetY=MapToScreenY(0,0)-this.offsetY;
    this.offsetX+=NewOffsetX;
    this.offsetY+=NewOffsetY;
  }
  var i=this.drops.length-1;
  do
  {
   var tdi=this.drops[i];
    tdi.h-=1;
    if(tdi.h>0)
    {INRS=false;
      if(tdi.h<100&&this.dosplash) {
	this.splashimages[tdi.i].blit(tdi.x,tdi.y);
    	if(++tdi.i==this.splashframesMax) tdi.h=0;
    	if(NewOffsetX) tdi.x=(tdi.x+NewOffsetX)%this.GSW;
    	if(tdi.x<0) tdi.x+=this.GSW;
    	if(NewOffsetY) tdi.y=(tdi.y+NewOffsetY)%(this.GSH);
      }
      else {
    	Line(tdi.x, tdi.y, tdi.x+this.lx, tdi.y+this.ly, this.raincolor);
	tdi.x=(tdi.x+this.wind+NewOffsetX)%this.GSW;
    	if(tdi.x<0) tdi.x+=this.GSW;
	tdi.y=(tdi.y+this.dropspeed+NewOffsetY)%(this.GSH);
      }
    }//#Endif(tdi.h>0)
    else 
    {
	var Floor=Math.floor;
	var Random=Math.random;
      if(this.moredrops) {
	tdi.y=Floor(Random()*this.GSH);
	tdi.h=Floor(Random()*this.GSH);
	tdi.i=0;
	if(this.thunder_probability&&(Random()<this.thunder_probability)) ApplyColorMask(this.raincolor);
      }
	else tdi.h=0;
    }
  }while(i--); this.raining=!INRS;
 }
}
